/*
 * Decompiled with CFR 0.152.
 */
package org.jear.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import org.jear.synth.SimpleSynth;
import org.jear.ui.Key;

public class Keyboard
extends JPanel
implements MouseListener {
    private SimpleSynth synth;
    private Vector whiteKeys;
    private Vector blackKeys;
    private Vector keys;
    private Key currentKey;
    final int kw = 20;
    final int kh = 100;

    public Keyboard() {
        this.setLayout(new BorderLayout());
        this.whiteKeys = new Vector();
        this.blackKeys = new Vector();
        this.keys = new Vector();
        this.currentKey = null;
        this.setPreferredSize(new Dimension(840, 101));
        int transpose = 24;
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] whiteIDs = nArray;
        int i = 0;
        int x = 0;
        while (i < 6) {
            int j = 0;
            while (j < 7) {
                int keyNum = i * 12 + whiteIDs[j] + transpose;
                this.whiteKeys.add(new Key(x, 0, 20, 100, keyNum));
                ++j;
                x += 20;
            }
            ++i;
        }
        i = 0;
        x = 0;
        while (i < 6) {
            int keyNum = i * 12 + transpose;
            this.blackKeys.add(new Key((x += 20) - 4, 0, 10, 50, keyNum + 1));
            this.blackKeys.add(new Key((x += 20) - 4, 0, 10, 50, keyNum + 3));
            x += 20;
            this.blackKeys.add(new Key((x += 20) - 4, 0, 10, 50, keyNum + 6));
            this.blackKeys.add(new Key((x += 20) - 4, 0, 10, 50, keyNum + 8));
            this.blackKeys.add(new Key((x += 20) - 4, 0, 10, 50, keyNum + 10));
            ++i;
            x += 20;
        }
        this.keys.addAll(this.blackKeys);
        this.keys.addAll(this.whiteKeys);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        Key key;
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.getSize();
        g2.setBackground(this.getBackground());
        g2.clearRect(0, 0, d.width, d.height);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, 840, 100);
        int i = 0;
        while (i < this.whiteKeys.size()) {
            key = (Key)this.whiteKeys.get(i);
            g2.setColor(Color.black);
            if (key.getIsOn()) {
                g2.setColor(Color.blue);
                g2.fill(key);
            }
            g2.draw(key);
            ++i;
        }
        i = 0;
        while (i < this.blackKeys.size()) {
            key = (Key)this.blackKeys.get(i);
            if (key.getIsOn()) {
                g2.setColor(Color.blue);
            } else {
                g2.setColor(Color.black);
            }
            g2.fill(key);
            ++i;
        }
    }

    public void playNotes(int[] notes, int duration) {
        try {
            int i = 0;
            while (i < notes.length) {
                Key key = this.getKey(notes[i]);
                key.setIsOn(true);
                this.synth.noteOn(key.getKeyNumber());
                this.repaint();
                Thread.sleep(duration);
                this.synth.noteOff(key.getKeyNumber());
                key.setIsOn(false);
                this.repaint();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Exception in playNotes: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setSynth(SimpleSynth synth) {
        this.synth = synth;
    }

    public SimpleSynth getSynth() {
        return this.synth;
    }

    public void mousePressed(MouseEvent e) {
        Key key = this.getKey(e.getPoint());
        key.setIsOn(true);
        this.synth.noteOn(key.getKeyNumber());
        this.repaint();
        this.currentKey = key;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.currentKey != null) {
            this.synth.noteOff(this.currentKey.getKeyNumber());
            this.currentKey.setIsOn(false);
            this.repaint();
            this.currentKey = null;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    protected Key getKey(Point point) {
        int i = 0;
        while (i < this.keys.size()) {
            if (((Key)this.keys.get(i)).contains(point)) {
                return (Key)this.keys.get(i);
            }
            ++i;
        }
        return null;
    }

    protected Key getKey(int note) {
        int i = 0;
        while (i < this.keys.size()) {
            if (((Key)this.keys.get(i)).getKeyNumber() == note) {
                return (Key)this.keys.get(i);
            }
            ++i;
        }
        return null;
    }
}

