/*
 * Decompiled with CFR 0.152.
 */
package org.jear.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;
import org.jear.lesson.Lesson;
import org.jear.lesson.Teacher;
import org.jear.ui.Keyboard;
import org.jear.ui.actions.MenuAbout;
import org.jear.ui.actions.MenuExit;
import org.jear.ui.actions.MenuNextLesson;
import org.jear.ui.actions.MenuPreviousLesson;
import org.jear.ui.actions.NextListener;
import org.jear.ui.actions.PlayListener;
import org.jear.ui.actions.PreviousListener;
import org.jear.ui.actions.ShowListener;

public class JearWindow
extends JFrame
implements Observer {
    private JLabel longDescription;
    private TitledBorder lessonBorder;
    private JButton play;
    private JButton next;
    private JButton previous;
    private JButton show;
    private JLabel questionLabel;
    private JLabel correctsLabel;
    private JLabel wrongsLabel;
    private JLabel averageLabel;
    private JLabel statusLabel;
    private JProgressBar lessonProgressBar;
    private Lesson currentLesson;
    private Teacher myTeacher;
    private Keyboard myKeyboard;

    public JearWindow(Keyboard keyboard, Teacher teacher) {
        super("JEAR");
        this.myKeyboard = keyboard;
        this.myTeacher = teacher;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.makeMenu(), "North");
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BoxLayout(aPanel, 1));
        this.getContentPane().add((Component)aPanel, "Center");
        JPanel lessonPanel = this.createLessonPanel();
        aPanel.add(lessonPanel);
        JPanel buttonsPanel = this.createButtonsPanel();
        aPanel.add(buttonsPanel);
        JPanel resultsPanel = this.createResultsPanel();
        aPanel.add(resultsPanel);
        JPanel statusPanel = this.createStatusPanel();
        aPanel.add(statusPanel);
        this.getContentPane().add((Component)this.myKeyboard, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setVisible(true);
    }

    private JPanel createResultsPanel() {
        JPanel resultsPanel = new JPanel();
        GridLayout grid = new GridLayout();
        grid.setHgap(10);
        grid.setVgap(10);
        resultsPanel.setLayout(grid);
        TitledBorder border = BorderFactory.createTitledBorder("");
        border.setTitle("Results");
        resultsPanel.setBorder(border);
        this.questionLabel = new JLabel();
        resultsPanel.add(this.questionLabel);
        this.lessonProgressBar = new JProgressBar();
        this.lessonProgressBar.setValue(0);
        this.lessonProgressBar.setForeground(Color.green);
        resultsPanel.add(this.lessonProgressBar);
        this.correctsLabel = new JLabel();
        resultsPanel.add(this.correctsLabel);
        this.wrongsLabel = new JLabel();
        resultsPanel.add(this.wrongsLabel);
        this.averageLabel = new JLabel();
        resultsPanel.add(this.averageLabel);
        return resultsPanel;
    }

    private JPanel createStatusPanel() {
        JPanel result = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder("");
        border.setTitle("Status");
        result.setBorder(border);
        this.statusLabel = new JLabel();
        result.setAlignmentX(0.5f);
        result.add(this.statusLabel);
        return result;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder("");
        border.setTitle("Actions");
        buttonsPanel.setBorder(border);
        this.previous = new JButton("<<Previous");
        this.previous.setToolTipText("Go back to previous question");
        this.previous.addActionListener(new PreviousListener(this.myTeacher));
        buttonsPanel.add(this.previous);
        this.play = new JButton("Play Question");
        this.play.setToolTipText("Play current question.");
        this.play.addActionListener(new PlayListener(this.myTeacher));
        buttonsPanel.add(this.play);
        this.next = new JButton("Next>>");
        this.next.setToolTipText("Continue to the next question - answer marked as wrong");
        buttonsPanel.add(this.next);
        this.next.addActionListener(new NextListener(this.myTeacher));
        this.show = new JButton("Show Answer");
        this.show.setToolTipText("Show the answer to current question");
        this.show.addActionListener(new ShowListener(this.myTeacher));
        buttonsPanel.add(this.show);
        return buttonsPanel;
    }

    private JPanel createLessonPanel() {
        JPanel lessonPanel = new JPanel();
        lessonPanel.setLayout(new BorderLayout());
        this.lessonBorder = BorderFactory.createTitledBorder("");
        this.lessonBorder.setTitle("");
        lessonPanel.setBorder(this.lessonBorder);
        this.longDescription = new JLabel();
        this.longDescription.setText("");
        lessonPanel.add((Component)this.longDescription, "West");
        return lessonPanel;
    }

    public void setLesson(Lesson aLesson) {
        this.currentLesson = aLesson;
        this.lessonBorder.setTitle(aLesson.getName());
        String desc = "<html><b>" + aLesson.getDescription() + "</b></html>";
        this.longDescription.setText(desc);
        this.lessonProgressBar.setMinimum(0);
        this.lessonProgressBar.setMaximum(this.currentLesson.getQuestionCount() - 1);
        this.update(null, null);
    }

    public void update(Observable o, Object arg) {
        if (this.currentLesson != this.myTeacher.getCurrentLesson()) {
            this.setLesson(this.myTeacher.getCurrentLesson());
        }
        String text = "Question #: " + (this.myTeacher.getCurrentLesson().getCurrentQuestionIndex() + 1);
        int answerState = this.myTeacher.getCurrentQuestion().getAnswerState();
        if (answerState == 2) {
            text = String.valueOf(text) + " (Wrong)";
        } else if (answerState == 3) {
            text = String.valueOf(text) + " (OK)";
        }
        this.questionLabel.setText(text);
        System.out.println(" label contents: " + text + " AS: " + answerState);
        this.correctsLabel.setText("Correct: " + this.currentLesson.getCorrects());
        this.wrongsLabel.setText("Wrong: " + this.currentLesson.getWrongs());
        this.lessonProgressBar.setValue(this.currentLesson.getCurrentQuestionIndex());
        if (this.myTeacher.getPercentWrong() > 50.0) {
            this.lessonProgressBar.setForeground(Color.red);
        } else if (this.myTeacher.getPercentWrong() > 25.0) {
            this.lessonProgressBar.setForeground(Color.orange);
        } else {
            this.lessonProgressBar.setForeground(Color.green);
        }
        this.averageLabel.setText("Average: " + this.myTeacher.getCurrentAverage());
        this.statusLabel.setForeground(Color.blue);
        this.statusLabel.setText("Listening for an answer...");
        if (this.myTeacher.getAnswerAttempted()) {
            if (answerState == 3) {
                this.statusLabel.setText("Correct Answer!");
            } else if (answerState == 2) {
                this.statusLabel.setForeground(Color.red);
                this.statusLabel.setText("Incorrect. You can try again!!");
            }
        }
        super.repaint();
    }

    public void setTeacher(Teacher v) {
        this.myTeacher = v;
    }

    protected JMenuBar makeMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = menuBar.add(new JMenu("File"));
        JMenuItem item = fileMenu.add(new JMenuItem("About"));
        item.addActionListener(new MenuAbout(this));
        item = fileMenu.add(new JMenuItem("Exit"));
        item.addActionListener(new MenuExit());
        JMenu lessonMenu = menuBar.add(new JMenu("Lessons"));
        JMenuItem itemLoad = lessonMenu.add(new JMenuItem("Load Lessons"));
        itemLoad.setEnabled(false);
        JMenuItem itemNext = lessonMenu.add(new JMenuItem("Next Lesson"));
        JMenuItem itemPrev = lessonMenu.add(new JMenuItem("Previous Lesson"));
        itemNext.addActionListener(new MenuNextLesson(this.myTeacher, itemNext, itemPrev));
        itemPrev.addActionListener(new MenuPreviousLesson(this.myTeacher, itemNext, itemPrev));
        itemPrev.setEnabled(false);
        lessonMenu.insertSeparator(1);
        return menuBar;
    }
}

