/*
 * Decompiled with CFR 0.152.
 */
package org.jear.tests;

import junit.framework.TestCase;
import org.jear.synth.SimpleSynth;

public class TestSimpleSynth
extends TestCase {
    private SimpleSynth synth;

    public TestSimpleSynth() {
        super("TestSimpleSynth");
    }

    protected void setUp() {
        try {
            System.out.println("Creating simple synth");
            this.synth = new SimpleSynth();
        }
        catch (Exception e) {
            System.out.println("Error creating synth");
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        this.synth.close();
    }

    protected void runTest() throws Throwable {
        this.testOneNote();
        this.testIntervalMelodic();
        this.testChordsMelodic();
        this.testIntervalHarmonic();
        this.testChordsHarmonic();
        this.testScale();
    }

    public void testOneNote() throws Throwable {
        System.out.println("Playing C:");
        int[] notes = new int[]{60};
        this.synth.playNotes(notes, true, 2000);
    }

    public void testIntervalMelodic() throws Throwable {
        System.out.println("Playing C and G");
        int[] notes = new int[]{60, 67};
        this.synth.playNotes(notes, true, 1000);
    }

    public void testChordsMelodic() throws Throwable {
        System.out.println("Playing Cmajor");
        int[] notes = new int[]{60, 64, 67};
        this.synth.playNotes(notes, true, 666);
    }

    public void testIntervalHarmonic() throws Throwable {
        System.out.println("Playing C and G");
        int[] notes = new int[]{60, 67};
        this.synth.playNotes(notes, false, 2000);
    }

    public void testChordsHarmonic() throws Throwable {
        System.out.println("Playing Cminor");
        int[] notes = new int[]{60, 63, 67};
        this.synth.playNotes(notes, false, 2000);
    }

    public void testScale() throws Throwable {
        System.out.println("Playing C major scale");
        int[] notes = new int[]{60, 62, 64, 65, 67, 69, 71, 72};
        this.synth.playNotes(notes, true, 1000);
        notes = new int[]{60, 62, 63, 65, 67, 69, 70, 72};
        System.out.println("Playing C dorian mode");
        this.synth.playNotes(notes, true, 1000);
    }
}

