/*
 * Decompiled with CFR 0.152.
 */
package org.jear.synth;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.jear.synth.IRecorder;

public class SimpleSynth {
    private int velocity = 64;
    private Synthesizer synth = MidiSystem.getSynthesizer();
    private MidiChannel channel_0;
    private IRecorder recorder;

    public SimpleSynth() throws Exception {
        this.synth.open();
        Soundbank sb = this.synth.getDefaultSoundbank();
        if (sb == null) {
            throw new Exception("No soundbanks defined in default synthesizer");
        }
        Instrument piano = null;
        Instrument[] inst = sb.getInstruments();
        int i = 0;
        while (i < inst.length) {
            if (inst[i].getName().equalsIgnoreCase("piano")) {
                piano = inst[i];
                break;
            }
            ++i;
        }
        if (piano == null) {
            throw new Exception("Cannot find 'piano' as the default instrument");
        }
        this.synth.loadInstrument(piano);
        this.channel_0 = this.synth.getChannels()[0];
    }

    public void setRecorder(IRecorder r) {
        this.recorder = r;
    }

    public void playNotes(int[] notes, boolean melodic, int duration) throws Exception {
        if (notes.length > 8) {
            throw new Exception("Only 8 notes or less can be played");
        }
        int i = 0;
        while (i < notes.length) {
            this.channel_0.noteOn(notes[i], this.velocity);
            if (this.recorder != null) {
                this.recorder.recordNote(notes[i]);
            }
            if (melodic) {
                Thread.sleep(duration);
                this.channel_0.noteOff(notes[i], this.velocity);
            }
            ++i;
        }
        if (!melodic) {
            Thread.sleep(duration);
            this.channel_0.allNotesOff();
        }
    }

    public void close() {
        this.channel_0.allNotesOff();
        this.synth.close();
    }

    public void noteOn(int note) {
        this.channel_0.noteOn(note, this.velocity);
        if (this.recorder != null) {
            this.recorder.recordNote(note);
        }
    }

    public void noteOff(int note) {
        this.channel_0.noteOff(note);
    }
}

