/*
 * Decompiled with CFR 0.152.
 */
package org.jear.lesson;

import java.util.Observable;
import java.util.Observer;
import org.jear.lesson.Lesson;
import org.jear.lesson.Question;
import org.jear.synth.AsynchRecorder;
import org.jear.synth.SimpleSynth;
import org.jear.ui.Keyboard;
import org.jear.ui.KeyboardPlayer;

public class Teacher
extends Observable
implements Observer {
    public static final int LISTENING_FOR_ANSWER = 1;
    public static final int ANSWER_CORRECT = 2;
    public static final int ANSWER_WRONG = 3;
    private Lesson currentLesson;
    private Question currentQuestion;
    private boolean answerAttempted;
    private SimpleSynth synth;
    private Keyboard keyboard;
    private KeyboardPlayer keyboardPlayer;
    private AsynchRecorder recorder;

    public Teacher(Keyboard kb) {
        this.keyboard = kb;
        this.synth = kb.getSynth();
        this.keyboardPlayer = new KeyboardPlayer(this.keyboard);
        this.keyboardPlayer.start();
        this.recorder = new AsynchRecorder();
        this.recorder.addObserver(this);
        this.answerAttempted = false;
    }

    public void setLesson(Lesson l) {
        System.out.println("Teacher.seltLesson called ");
        this.currentLesson = l;
        this.currentLesson.start();
        this.currentQuestion = (Question)this.currentLesson.next();
        this.setChanged();
        this.notifyObservers();
    }

    public Lesson getCurrentLesson() {
        return this.currentLesson;
    }

    public Question getCurrentQuestion() {
        return this.currentQuestion;
    }

    public double getCurrentAverage() {
        double c = this.currentLesson.getCorrects();
        double t = this.currentLesson.getQuestionCount();
        return 100.0 * (c / t);
    }

    public double getPercentWrong() {
        double w = this.currentLesson.getWrongs();
        double t = this.currentLesson.getQuestionCount();
        return 100.0 * (w / t);
    }

    public void askQuestion() throws Exception {
        this.synth.setRecorder(null);
        this.answerAttempted = false;
        if (this.currentQuestion == null) {
            throw new Exception("CurrentQuestion is null");
        }
        System.out.println("Current q: " + this.currentLesson.getCurrentQuestionIndex() + " qid:" + this.currentQuestion + " melodic: " + this.currentLesson.getMelodic());
        this.synth.playNotes(this.currentQuestion.getNotes(), this.currentLesson.getMelodic(), 1000);
        this.recorder.reset();
        this.synth.setRecorder(this.recorder);
    }

    public void skipToNextQuestion() {
        if (this.currentQuestion.getAnswerState() == 1) {
            System.out.println("skipToNextQuestion: marking wrong. #");
            this.currentQuestion.markWrong();
        }
        this.moveToNextQuestion();
        this.synth.setRecorder(null);
        this.setChanged();
        this.notifyObservers();
    }

    public void skipToPreviousQuestion() {
        if (this.currentLesson.hasPrevious()) {
            this.currentQuestion = (Question)this.currentLesson.previous();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void showAnswer() {
        if (this.currentQuestion != null) {
            this.synth.setRecorder(null);
            this.keyboardPlayer.playNotes(this.currentQuestion.getNotes());
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean getAnswerAttempted() {
        return this.answerAttempted;
    }

    public void update(Observable observed, Object arg) {
        if (this.recorder.getCount() >= this.currentQuestion.getNotes().length) {
            this.currentQuestion.checkAnswer(this.recorder.getNotes());
            this.answerAttempted = true;
            this.recorder.reset();
            this.setChanged();
            this.notifyObservers();
        }
    }

    private void moveToNextQuestion() {
        this.currentQuestion = this.currentLesson.hasNext() ? (Question)this.currentLesson.next() : null;
        System.out.println("Move to next question called: " + this.currentQuestion);
    }
}

