/*
 * Decompiled with CFR 0.152.
 */
package org.jear;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.midi.Synthesizer;

public class SoundExample {
    public SoundExample() throws Exception {
        Synthesizer synth = MidiSystem.getSynthesizer();
        synth.open();
        System.out.println("Got Synthsizer");
        Soundbank sb = synth.getDefaultSoundbank();
        if (sb == null) {
            System.out.println("No sound banks");
        } else {
            Instrument[] inst = sb.getInstruments();
            System.out.println("Instruments loaded: " + inst.length);
            SoundbankResource piano = null;
            int i = 0;
            while (i < inst.length) {
                if (inst[i].getName().equals("Tubular Bell")) {
                    piano = inst[i];
                }
                ++i;
            }
            if (piano != null) {
                System.out.println("Found:" + piano.getName());
                synth.loadInstrument((Instrument)piano);
                System.out.println("Count of loaded inst: " + synth.getLoadedInstruments().length);
                MidiChannel mc = synth.getChannels()[0];
                mc.noteOn(60, 74);
                System.out.println("Sound should be playing");
                mc.noteOn(63, 64);
                mc.noteOn(67, 64);
                mc.noteOn(69, 64);
                int i2 = 0;
                while (i2 < 7) {
                    System.out.println("tick..");
                    Thread.sleep(1000L);
                    ++i2;
                }
                mc.noteOff(63, 64);
                mc.noteOff(67, 64);
                mc.noteOff(60, 64);
                mc.noteOff(69, 64);
            }
        }
        System.out.println("Done with tests...");
        synth.close();
    }

    public static void main(String[] argv) throws Exception {
        SoundExample ex = new SoundExample();
        System.out.println("Exiting");
        System.exit(0);
    }
}

